C  Include file:
C      'plotdata.for'

C      Does all the plotting to the screen



	SUBROUTINE PlotData ()
	INCLUDE 'Fgraph.FD'
	Include 'include\mainvar.for'
	Include 'include\comblock.for'
	
	dummy2 = settextcolor (15)

c  **   PLOT  THE  STUFF  HERE   **
C    SCALING:
c	  Write (60,*) 'maxx: ',maxx,' maxy: ',maxy
	  x1 = maxx*0.1
	  x2 = maxx*0.9
	  y1 = maxy*0.1
	  y2 = maxy*0.9



	  maxtime = 0.0
	  maxmag = -10.0   ! way out there....
	  mintime = 1001.0  ! above any reasonable value
	  minmag = 40.0


c  SHOULD REPLACE THESE WITH THE FORTRAN INTRINSIC FUNCTIONS
	  do I=1,points      ! find max and min date
	     IF (jdate(I).gt.maxtime) maxtime = jdate(I)
	     If (jdate(I).lt.mintime) mintime = jdate(I)
	     if (mag2(I).gt.maxmag)   maxmag = mag2(I)
	     if (mag2(I).lt.minmag)   minmag = mag2(I)
	  enddo

C  Find average value:
	  jdatesum = 0.0
	  magsum = 0.0

	  do I=1,points
	     jdatesum = jdatesum + jdate(I)
	     magsum = magsum + mag2(I)
	  ENDDO
	  avejdate = jdatesum / points
	  avemag = magsum / points

C  set range:
	  If ((maxmag - avemag) .LT. (minrange/2.0)) Then
	     maxmag = avemag + (minrange/2.0)
	     minmag = avemag - (minrange/2.0)
	  ELSE If ((maxmag - avemag) .GT. (maxrange/2.0)) Then
	     maxmag = avemag + (maxrange/2.0)
	     minmag = avemag - (maxrange/2.0)
	  ENDIF
C  Default above is to leave the data to range itself by max & min

	  mxt = maxtime
	  mnt = mintime
	  mxm = maxmag
	  mnm = minmag


	  call label(mxt,mnt,mxm,mnm,x1,x2,y1,y2,tabletype)

C  Prepare screen
	  call drawgraph()   ! draw the graph
	  call title(HDnum, HDrel, GRPno, mintime, maxtime, filter)
	
	  DO I=1,points
	     IF ((mag2(I).LT.minmag).OR.(mag2(I).GT.maxmag)) GOTO 961
C               ^^^ if out of range, don't plot the point

	     m = mag2(I)
	     deltam = (maxmag - minmag)
	     x = x1+ (x2-x1)*(jdate(I)-mintime)/(maxtime-mintime)
	     y = y2 - (y2-y1)*(mag2(i)-minmag)/(maxmag-minmag)
	     dummy = rectangle ($GFILLINTERIOR , x-2, y-2, x+2, y+2)



	     IF ((TableType.EQ.'N').AND.(Ebars.EQ.'y')) Then
	     Barlength = y2-(y2-y1)*(m+Err(i)/100-minmag)/deltam - y

		CALL moveto (x-2,y+barlength, xy)
	        dummy = lineto (x+2,y+barlength)
	        CALL moveto (x,y+barlength, xy)
	        dummy = lineto (x,y-barlength)
		CALL moveto (x-2,y-barlength, xy)
	        dummy = lineto (x+2,y-barlength)

	     ENDIF

961	     Continue

	  enddo

	  END