C  Include file:
C      'g-rout.for'

C      Contains subroutines for graphics.




C     Graphics stuff:





C---------------------------------------------------------------------
	  SUBROUTINE graphicsmode()

	  include 'FGRAPH.FD'

 	  integer*2           dummy, maxx, maxy
	  RECORD /videoconfig/ myscreen
	  COMMON	      maxx, maxy

C
C     Find graphics mode.
C

	  CALL getvideoconfig( myscreen )
	  select case( myscreen.adapter )
	     case( $CGA )
	        dummy = setvideomode( $HRESBW )
	        Write (60,*) '$CGA'
	     case( $OCGA )
	        dummy = setvideomode( $ORESCOLOR )
	        Write (60,*) '$OCGA'
	     case( $EGA, $OEGA )
	        dummy = setvideomode ( $ERESCOLOR )
	        Write (60,*) '$EGA'
	     case( $VGA, $OVGA, $MCGA )
	        dummy = setvideomode ( $VRES2COLOR )
	        Write (60,*) '$VRES16COLOR'
	     case default
	        dummy = setvideomode( $HRESBW )
	        Write (60,*) 'Default = $HRESBW'
	  end select

C
C	  Determine the min and max dimensions.
C

	  CALL getvideoconfig( myscreen )
	  maxx = myscreen.numxpixels - 1
	  maxy = myscreen.numypixels - 1
	
	
	
	  END

C --------------------------------------------------------------------


C      Title the graph

	  SUBROUTINE TITLE(HDnum, HDrel, GRPno, Mindate,maxdate,filter)

	  include 'FGRAPH.FD'

	  real		   mindate, maxdate
	  integer*2        getdat, i, idy, iyr, imo
	  character*10     textdate
	  character*6      HDnum, HDrel
	  Character*3      GRPno
	  Character*4      textjdate,ptext
	  Integer	   filter
	  Character*3      filtertext

	  RECORD /rccoord/ curpos


c	  HDrel = '113022'

	  call settextposition (1, 10, curpos)
	  call outtext ('BRIGHTNESS OF HD ')
	  call outtext (HDnum)
	  call outtext (' RELATIVE TO HD ')
	  call outtext (HDrel)		!  get the relative star here
	  call outtext (' GRP ')
	  call outtext (GRPno)			!  Put the group number here
	  call settextposition (2, 10, curpos)

	  If (filter .eq. 2) filtertext = 'BLU'
	  If (filter .eq. 3) filtertext = 'VIS'

	  call outtext (filtertext)
	  call outtext (' FILTER RESULTS (')


	  i = getdat (iyr,imo,idy)
	  write (textdate,'(I2,A1,I2,A1,I4)') imo,'-',idy,'-',iyr

	  call outtext (textdate)        !  Fit in the current date
	  call outtext (') on JD ')


	  IF ((maxdate-mindate) .LT. 1) THEN  ! this is for within one night
	     write (textjdate,'(I4)') Int2(mindate)
	     call outtext (textjdate)
	  Endif


	  IF ((maxdate-mindate) .GE. 1) THEN    ! This is for night plots
	     write (textjdate,'(I4)') INT2(mindate)
	     call outtext (textjdate)
	     call outtext (' TO ')
	     write (textjdate,'(I4)') INT2(maxdate)
	     call outtext (textjdate)
	  Endif


	  End

C --------------------------------------------------------------------

CC DRAWGRAPH - this program draws the lines for the box and ticks
c   DONE


	  SUBROUTINE drawgraph()

	  include 'fgraph.fd'

	  integer*2	x1, x2, y1, y2, dummy, maxx, maxy
	  integer*2	xstep, ystep, jump, xtick, ytick
	  RECORD /xycoord/ xy
c	  COMMON        maxx,maxy
	  RECORD /videoconfig/ myscreen

	  CALL getvideoconfig( myscreen )
	  maxx = myscreen.numxpixels - 1
	  maxy = myscreen.numypixels - 1

	  x1 = maxx*0.1
	  x2 = maxx*0.9
	  y1 = maxy*0.1
	  y2 = maxy*0.9
	  xstep = (x2-x1)/10
	  xtick = y1*0.15
	  ystep = (y2-y1)/10
	  ytick = x1*0.15
	  dummy = rectangle ($GBORDER,x1,y1,x2,y2)

	
	  Do  I=1,9
C     Plot Xaxis tick
	     jump = x1+I*xstep
	     call    moveto (jump, y1, xy)
	     dummy = lineto (jump, y1+(xtick ))
	     call    moveto (jump, y2-(xtick), xy)
	     dummy = lineto (jump, y2)
C     Plot Ytick
	     jump = y1+I*ystep
	     call    moveto (x1, jump, xy)
	     dummy = lineto (x1+(ytick), jump)
	     call    moveto (x2, jump, xy)
    	     dummy = lineto (x2-(ytick), jump)
	  enddo



	  END	


C -----------------------------------------------------------------

	  SUBROUTINE label(maxtime,mintime,maxmag,minmag,x1,x2,y1,y2,tt)

	  include 'FGRAPH.FD'
	  RECORD /rccoord/ curpos
	  RECORD /xycoord/ xy
	  Character*2 temp
	  Character*6 magnitude
	  Character*5 juliantime
	  Character*10 temptext
	  Real   maxtime,mintime
	  Real   maxmag,minmag,jump
	  Integer*2 maxx,maxy
c	  COMMON    maxx,maxy
	  Integer*2 x1,x2,y1,y2, x, y
	  Integer   k
c	  COMMON    x1,x2,y1,y2
	  RECORD /videoconfig/ myscreen

	  character*1 tt

	  integer*2   hr,minute,temp1
	  real        time,time2,a


	  CALL getvideoconfig( myscreen )
	  maxx = myscreen.numxpixels - 1
	  maxy = myscreen.numypixels - 1


	  call settextposition (11, 1, curpos)
	  call outtext ('M')
	  call settextposition (12, 1, curpos)
	  call outtext ('A')
	  call settextposition (13, 1, curpos)
	  call outtext ('G')
	  call settextposition (14, 1, curpos)
	  call outtext ('N')
	  call settextposition (15, 1, curpos)
	  call outtext ('I')
	  call settextposition (16, 1, curpos)
	  call outtext ('T')
	  call settextposition (17, 1, curpos)
	  call outtext ('U')
	  call settextposition (18, 1, curpos)
	  call outtext ('D')
	  call settextposition (19, 1, curpos)
	  call outtext ('E')

	  IF (Tt .EQ. 'N') Then
	     call settextposition (29, 30, curpos)
	     call outtext ('Julian Date (JD-2448000)')
	  ELSE
	     call settextposition (29,34, curpos)
	     call outtext ('UT TIME')
	  ENDIF

	  dummy = setfont ('n5')

	  jump = (maxmag-minmag)/10.0
	  DO k=0,10
	     x = Int2 ( x1*0.4 )
	     y = Int2 ( y2 - (1.09)*k*(y2-y1)/11.0 - maxy*0.015)
	     call moveto ( x, y, xy)
	     write (magnitude,'(F6.4)') minmag + (jump*k)
	     call outgtext (magnitude)
 	  enddo


	  jump = (maxtime-mintime)/10.0


	  DO k=0,10
	     x = Int2 ( x1 + (1.1)*k*(x2-x1)/11.0 - maxx*0.025)
	     y = y2+(maxy-y2)*0.1
	     call moveto ( x, y, xy)
	     IF (TT .EQ. 'N') Then
	        write(temptext,'(f10.4)') mintime+(jump*k) ! internal write
	        juliantime = temptext (1:5)    !  pick off the 1st 5 places
	        call outgtext (juliantime)
	     ELSE
	        time = mintime+(jump*k)
	        a = time - Int(time)
	        time2 = (a*24)
	        hr = Int2(time2)
	        minute = Int2((time2 - REAL(hr))*60)
	        hr = hr - 12  !  change from JD to UT time
	        IF (hr .LT. 0.0) hr = hr + 24
		IF (minute .GT. 9) Then
	           write (juliantime,'(I2,A1,I2)') hr,':',minute
	        ELSE
	           write (juliantime,'(I2,A2,I1)') hr,':0',minute
		ENDIF
	        call outgtext (juliantime)
	     ENDIF
	  enddo


	  END


C    END END END END END END END END END END END END END END END END END END	
	